/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.fsp;

import com.ibm.hsc.common.exceptions.PIHscCmdMgrException;
import com.ibm.hsc.common.exceptions.PIHscCmdMgrRetryException;
import com.ibm.hsc.common.exceptions.PISystemException;
import com.ibm.hsc.common.util.CmdExtendedErrorList;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.common.util.HardwareServerMessage;
import com.ibm.hsc.common.util.HexDump;
import com.ibm.hsc.common.util.MsVersionInfo;
import com.ibm.hsc.common.util.PIBuildCommandPacket;
import com.ibm.hsc.common.util.PIParseResponse;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.fsp.AsyncEventListener;
import com.ibm.hsc.fsp.ConsoleCmdMgr;
import com.ibm.hsc.fsp.FSPCMCustomHWSMessage;
import com.ibm.hsc.fsp.FSPCMIdGenerator;
import com.ibm.hsc.fsp.FSPCMReqTable;
import com.ibm.hsc.fsp.FSPCMReqTableEntry;
import com.ibm.hsc.fsp.FSPCMRespHdlr;
import com.ibm.hsc.fsp.FSPCMRespThread;
import com.ibm.hsc.fsp.FSPCMUtils;
import com.ibm.hsc.fsp.FSPCmdMgr;
import com.ibm.hsc.fsp.FspCmdToken;
import com.ibm.hsc.fsp.FspConnErrorHandler;
import com.ibm.hsc.fsp.FspInDataHandler;
import com.ibm.hsc.fsp.FspNoRespCmd;
import com.ibm.hsc.fsp.HWSvrSocket;
import com.ibm.hsc.fsp.cmdhelpers.FspQueryData;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.snia.wbem.cim.UnsignedInt16;

public class ManagedSysConn
implements FspInDataHandler {
    private FSPCmdMgr mCmdMgr;
    private int mVport;
    private HWSvrSocket mHWSocket = null;
    private FSPCMReqTable mCmReqTable;
    private FSPCMIdGenerator mIdGen;
    private FspConnErrorHandler mConnErrorHandler = null;
    private AsyncEventListener mAsyncListener = null;
    private Vector mNoRespCmds = new Vector();
    private boolean mClosed = false;
    private boolean mIsPrimary = true;
    private FspQueryData mQueryData = null;
    private long mLastNoConnTime = 0L;
    private String mLocCode = null;
    private boolean mResetFailOverFsp = false;
    public static int DEFAULT_TIMEOUT;
    private static int mTimeoutValue;
    private static final int MAX_NO_RESP_CMD_SIZE = 10;
    private static final int MIN_TIMEOUT = 3000;
    public static final int FSP_CM_SUCCESS = 0;
    public static final int FSP_CM_NOT_IN_TABLE = 1;

    ManagedSysConn(FSPCmdMgr fSPCmdMgr, int n, AsyncEventListener asyncEventListener, FspConnErrorHandler fspConnErrorHandler, FspQueryData fspQueryData) throws PIHscCmdMgrException {
        this.mCmdMgr = fSPCmdMgr;
        this.mAsyncListener = asyncEventListener;
        this.mConnErrorHandler = fspConnErrorHandler;
        this.mVport = n;
        this.mHWSocket = HWSvrSocket.getInstance();
        this.mHWSocket.addVport(this.mVport, this);
        this.mCmReqTable = new FSPCMReqTable();
        this.mIdGen = FSPCMIdGenerator.getInstance();
        this.updateData(fspQueryData);
    }

    boolean everRunResetFailCmd() {
        return this.mResetFailOverFsp;
    }

    void setEverRunResetFailCmd() {
        this.mResetFailOverFsp = true;
    }

    public int getConnState() {
        if (this.mQueryData != null) {
            return this.mQueryData.getCmdServerConnState().intValue();
        }
        return 32768;
    }

    public void updateData(FspQueryData fspQueryData) {
        System.out.println("update conn data for " + this.mVport);
        int n = this.getConnState();
        if (this.mQueryData != null && this.mQueryData.getChangeTime() > fspQueryData.getChangeTime()) {
            return;
        }
        this.mQueryData = fspQueryData;
        if (n == this.getConnState()) {
            return;
        }
        System.out.println("set IsPrimary");
        this.mIsPrimary = !fspQueryData.isFrame() && fspQueryData.getFspRole().intValue() == 1;
        this.setLocCode(fspQueryData.getLocationCode());
        if (this.isConnected(this.getConnState())) {
            int n2 = MsVersionInfo.isCompatible("V4R3.2", fspQueryData.getInterfaceVersionFamily().intValue(), fspQueryData.getFspType().intValue(), fspQueryData.getMajorVersion().intValue(), fspQueryData.getMinorVersion().intValue(), fspQueryData.getBrand().intValue());
            System.out.println("MsVersionInfo.isCompatible: " + n2);
            if (n2 != 0) {
                this.mQueryData.setCmdServerConnState(new UnsignedInt16(32775));
            }
        }
        System.out.println("mConnState " + this.getConnState());
        if (!this.isConnected(this.getConnState()) && this.isConnected(n)) {
            if (this.mConnErrorHandler != null) {
                this.mConnErrorHandler.sysDisconnected(this.mQueryData.getChangeTime());
            }
            this.disable(2, this.mQueryData.getChangeTime());
        }
    }

    public boolean isPrimary() {
        return this.mIsPrimary;
    }

    private boolean isConnected(int n) {
        return n == 0 || n == 11 || n == 32773 || n == 16;
    }

    public boolean isConnected() {
        return this.isConnected(this.getConnState());
    }

    public void close() {
        this.disable(3, System.currentTimeMillis());
    }

    public String getHypPipeAsychCmd(int n) {
        FSPCMReqTableEntry fSPCMReqTableEntry = this.mCmReqTable.getByCmdId(n);
        String string = fSPCMReqTableEntry.getAsynchCmd();
        return string;
    }

    public int processGroupResponse(byte[] byArray, int n) {
        PISystemException pISystemException = null;
        boolean bl = false;
        FSPCMReqTableEntry fSPCMReqTableEntry = this.mCmReqTable.getByCmdId(n);
        if (fSPCMReqTableEntry == null) {
            return 1;
        }
        int n2 = fSPCMReqTableEntry.getReqId();
        FSPCMRespHdlr fSPCMRespHdlr = fSPCMReqTableEntry.getRespHdlr();
        try {
            Object object;
            PIParseResponse pIParseResponse = new PIParseResponse(byArray);
            if (!pIParseResponse.isNoErrorStatusResponse()) {
                object = pIParseResponse.getErrorData();
                int n3 = (Integer)((Hashtable)object).get("ERROR_TYPE");
                if (n3 == 33006) {
                    CmdExtendedErrorList cmdExtendedErrorList = (CmdExtendedErrorList)((Hashtable)object).get("ERROR_DATA");
                    pISystemException = new PISystemException(fSPCMReqTableEntry.getCmd(), cmdExtendedErrorList);
                } else {
                    pISystemException = new PISystemException(fSPCMReqTableEntry.getCmd(), n3);
                }
            }
            object = fSPCMReqTableEntry.getAsynchCmd();
            Hashtable hashtable = null;
            if (((String)object).equals("HYPER_PIPE_RESP_ASYNC_EXCH_CAPS")) {
                try {
                    hashtable = pIParseResponse.getParsedData((String)object);
                }
                catch (Throwable throwable) {
                    System.out.println("processGroupResponse - exch caps parse error - retry!");
                    PIParseResponse pIParseResponse2 = new PIParseResponse(byArray);
                    hashtable = pIParseResponse2.getParsedData("HYPER_PIPE_RESP_ASYNC");
                    System.out.println("Retry - the parsed data is: " + hashtable);
                }
            } else {
                hashtable = pIParseResponse.getParsedData((String)object);
            }
            int n4 = fSPCMRespHdlr.processResp(hashtable, n);
            this.mCmReqTable.deleteRow(n2);
            switch (n4) {
                case 0: {
                    break;
                }
                case 1: {
                    this.cleanupTable(fSPCMReqTableEntry.getGroupId());
                    bl = true;
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    this.cleanupTable(fSPCMReqTableEntry.getGroupId());
                    bl = true;
                    break;
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        System.out.println("Wakeup group cmd thread");
        if (bl || this.mCmReqTable.emptyGroup(fSPCMReqTableEntry.getGroupId())) {
            FSPCMUtils.wakeupReqThread(fSPCMReqTableEntry);
        }
        return 0;
    }

    private void cleanupTable(int n) {
        Trace.trace("apcmhscT", "Entering cleanupTable");
        int n2 = 0;
        int[] nArray = this.mCmReqTable.getByGroupId(n);
        while (nArray != null && nArray.length > 0) {
            this.mCmReqTable.deleteRow(nArray[n2]);
            ++n2;
        }
    }

    public HardwareServerMessage doHardwareServerCmd(String string, FSPCMCustomHWSMessage fSPCMCustomHWSMessage, byte[] byArray, int n) throws PIHscCmdMgrException {
        byte[] byArray2;
        Object object;
        Object var5_5 = null;
        if (n < 3000) {
            n = mTimeoutValue;
        }
        int n2 = this.mIdGen.genReqId();
        try {
            object = HardwareServerMessage.buildCustomHWSMessage(fSPCMCustomHWSMessage.getMajorOpcode(), fSPCMCustomHWSMessage.getMinorOpcode(), this.mVport, n2, byArray);
            byArray2 = ((HardwareServerMessage)object).toBytes();
            if (ConsoleCmdMgr.printDetail() || !string.equals("PLATFORM_PASSWORD")) {
                System.out.println("Cmd send to hardware server: " + new HexDump(byArray2, false).toString());
            } else {
                System.out.println("ConsoleCmdMgr.printDetail(): " + ConsoleCmdMgr.printDetail() + " cmd " + string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            HSCLogUtils.serverLog(exception, HSCLogUtils._CECClassLogInfo);
            throw new PIHscCmdMgrException("0204", exception);
        }
        try {
            object = new FspCmdToken();
            this.mCmReqTable.addRow(n2, string, Thread.currentThread(), (FspCmdToken)object, 1);
            this.mHWSocket.sendCommand(byArray2);
            Trace.trace("apcmhscD", "FSPCmdMgr:  Packet sent.");
            ((FspCmdToken)object).sleep(n);
        }
        catch (InterruptedException interruptedException) {
            Trace.trace("apcmhscD", "FSPCmdMgr: EXPLICITLY woken up the request thread...");
        }
        catch (IOException iOException) {
            HSCLogUtils.serverLog(iOException, HSCLogUtils._CECClassLogInfo);
            throw new PIHscCmdMgrException("0204", iOException);
        }
        object = (HardwareServerMessage)this.procResp(n2);
        if (object == null) {
            throw new PIHscCmdMgrException("0254", new String[]{string}, (PIHscCmdMgrException)null);
        }
        return object;
    }

    public Hashtable internalRunCmd(String string, String[] stringArray, int n, byte[] byArray) throws PIHscCmdMgrException {
        PIHscCmdMgrException pIHscCmdMgrException = null;
        boolean bl = false;
        int n2 = 0;
        int n3 = this.mVport;
        if (n == 0 || n < 3000) {
            n = mTimeoutValue;
        }
        if (stringArray != null) {
            System.out.println("args.length = " + stringArray.length);
        } else {
            System.out.println(" no arguments");
        }
        byte[] byArray2 = null;
        try {
            byArray2 = PIBuildCommandPacket.buildCommand(string, stringArray, byArray);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new PIHscCmdMgrException("message", throwable);
        }
        boolean bl2 = (byArray2[14] & 8) != 0 || (byArray2[14] & 0x80) != 0;
        Thread thread = Thread.currentThread();
        while (n2 < 3) {
            System.out.println("calling doFSPCommand: " + string);
            int n4 = this.mIdGen.genReqId();
            Hashtable hashtable = null;
            try {
                FspCmdToken fspCmdToken = new FspCmdToken();
                if (bl2) {
                    this.mCmReqTable.addRow(n4, string, thread, fspCmdToken, 0);
                } else {
                    for (int i = 0; i < byArray2.length; ++i) {
                        System.out.println("cmdBytes[" + i + "] = " + Integer.toHexString(byArray2[i]));
                    }
                    System.out.println("this cmd doesn't need resp");
                    if (this.mNoRespCmds.size() > 10) {
                        this.mNoRespCmds.remove(0);
                    }
                    this.mNoRespCmds.addElement(new FspNoRespCmd(n4, string, byArray2));
                }
                this.submitCmd(string, byArray2, n4, n3, n);
                if (!bl2) {
                    System.out.println("don't need resp, return after submit");
                    return null;
                }
                fspCmdToken.sleep(n);
                bl = true;
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                pIHscCmdMgrException = new PIHscCmdMgrException("message", throwable);
            }
            try {
                hashtable = (Hashtable)this.procResp(n4);
                if (hashtable == null) {
                    if (bl) {
                        System.out.println("FSPCmdMgr:  Request timed out.");
                    } else {
                        System.out.println("FSPCmdMgr:  Request did not time out.");
                    }
                    throw new PIHscCmdMgrException("FSPCmdMgr", -1);
                }
                return hashtable;
            }
            catch (PIHscCmdMgrRetryException pIHscCmdMgrRetryException) {
                if (!(string.equals("RESET_HMC_LOCKS_V2") || string.equals("ACKNOWLEDGE_OUTSTANDING_EVENTS") || string.equals("ACKNOWLEDGE_PLATFORM_DUMP") || string.equals("ACKNOWLEDGE_PLATFORM_EVENT_LOG_ENTRY"))) {
                    ++n2;
                }
                if (n2 != 3) continue;
                throw pIHscCmdMgrRetryException;
            }
        }
        return null;
    }

    public int[] doGroupCmd(Vector vector, String string, String string2, int[] nArray, FSPCMRespHdlr fSPCMRespHdlr, int n) throws PIHscCmdMgrException {
        byte[] byArray = (byte[])vector.elementAt(0);
        System.out.println("tmpcmd: " + byArray);
        String string3 = new String(byArray);
        long l = System.currentTimeMillis();
        int n2 = this.mIdGen.genGroupId();
        int[] nArray2 = null;
        Thread thread = Thread.currentThread();
        for (int i = 0; i < vector.size(); ++i) {
            byte[] byArray2 = (byte[])vector.elementAt(i);
            int n3 = this.mIdGen.genReqId();
            Trace.trace("apcmhscD", "FSPCmdMgr:  Next request Id = " + n3);
            this.mCmReqTable.addRow(n3, string, string2, thread, n2, nArray[i], fSPCMRespHdlr);
            Trace.trace("apcmhscD", "FSPCmdMgr:  Sending cmd to hardware server.");
            this.submitCmd(null, byArray2, n3, this.mVport, n);
            Trace.trace("apcmhscD", "FSPCmdMgr:  Sending cmd to hardware server.");
        }
        long l2 = System.currentTimeMillis();
        try {
            long l3 = (long)n - (l2 - l);
            Trace.trace("apcmhscD", "FSPCmdMgr:  Sleeping waiting for response for " + l3 + " millisecs");
            if (l3 > 0L) {
                Thread.sleep((long)n - (l2 - l));
            }
        }
        catch (InterruptedException interruptedException) {
            Trace.trace("apcmhscD", "FSPCmdMgr: Explicitly woken up");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        nArray2 = this.getTOIds(n2);
        Trace.trace("apcmhscT", "Exiting doGroupCmd");
        return nArray2;
    }

    private int[] getTOIds(int n) {
        return this.mCmReqTable.getCmdIds(n);
    }

    private void submitCmd(String string, byte[] byArray, int n, int n2, int n3) throws PIHscCmdMgrException {
        try {
            short s = (short)(n3 / 2000);
            System.out.println("JPD:  Sending hwsTimeoutInSecs = " + s);
            int n4 = this.mCmdMgr.isFsp() ? 96 : 115;
            HardwareServerMessage hardwareServerMessage = new HardwareServerMessage(80, n4, n2, n, byArray, s);
            byArray = hardwareServerMessage.toBytes();
            if (ConsoleCmdMgr.printDetail() || string != null && !string.equals("SET_PASSWORDS") && !string.equals("PLATFORM_PASSWORD")) {
                System.out.println("Cmd send to hardware server: " + new HexDump(byArray, false).toString());
            } else {
                System.out.println("ConsoleCmdMgr.printDetail() " + ConsoleCmdMgr.printDetail() + " cmd " + string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            HSCLogUtils.serverLog(exception, HSCLogUtils._CECClassLogInfo);
            throw new PIHscCmdMgrException("0204", exception);
        }
        try {
            System.out.println("mHWSocket: " + this.mHWSocket);
            this.mHWSocket.sendCommand(byArray);
            Trace.trace("apcmhscD", "FSPCmdMgr:  Packet sent.");
        }
        catch (IOException iOException) {
            HSCLogUtils.serverLog(iOException, HSCLogUtils._CECClassLogInfo);
            throw new PIHscCmdMgrException("0204", iOException);
        }
    }

    public void disconnect(boolean bl, long l) {
        if (bl) {
            this.disable(3, l);
            if (this.mConnErrorHandler != null) {
                this.mConnErrorHandler.hwSrvDisconnected(l);
            }
        } else {
            this.disable(2, l);
            if (this.mConnErrorHandler != null) {
                this.mConnErrorHandler.sysDisconnected(l);
            }
        }
    }

    private void disable(int n, long l) {
        if (this.mClosed) {
            System.out.println("Connection for vport " + this.mVport + " already closed");
            return;
        }
        System.out.println("clear the req table");
        this.mCmReqTable.clear(n);
        if (n == 3) {
            System.out.println("closing connection for " + this.mVport);
            this.mClosed = true;
            if (this.mHWSocket != null) {
                this.mHWSocket.removeVport(this.mVport);
            }
        }
        if (this.isConnected(this.getConnState())) {
            this.mQueryData.setCmdServerConnState(new UnsignedInt16(32768));
        }
        if (l > this.mQueryData.getChangeTime()) {
            this.mQueryData.setChangeTime(l);
        }
    }

    public int getVport() {
        return this.mVport;
    }

    public String getIpAddr() {
        return this.mQueryData.getIpAddress();
    }

    public String getLocCode() {
        return this.mQueryData.getLocationCode();
    }

    void setLocCode(String string) {
        System.out.println("set loc code to " + string);
        this.mLocCode = string;
    }

    public String getSPVersion() {
        return this.mQueryData.getVersionStr();
    }

    public static void setTimeoutValue(int n) {
        mTimeoutValue = n;
    }

    FspQueryData getQueryData() {
        return this.mQueryData;
    }

    void retryNoRespCmd(int n) {
        for (int i = 0; i < this.mNoRespCmds.size(); ++i) {
            FspNoRespCmd fspNoRespCmd = (FspNoRespCmd)this.mNoRespCmds.elementAt(i);
            if (fspNoRespCmd.getReqId() != n) continue;
            if (!fspNoRespCmd.increaseRetryTime()) break;
            System.out.println("retrying cmd " + fspNoRespCmd.getCmdStr());
            try {
                this.submitCmd(null, fspNoRespCmd.getCmd(), n, this.mVport, 0);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            break;
        }
    }

    void setOutDataForGroupCmd(FSPCMReqTableEntry fSPCMReqTableEntry, HardwareServerMessage hardwareServerMessage) {
        Object object;
        Hashtable hashtable = null;
        if (hardwareServerMessage != null && (hardwareServerMessage.getMajorOpCode() != 80 || hardwareServerMessage.getMinorOpCode() != 98)) {
            try {
                PIParseResponse pIParseResponse = new PIParseResponse(hardwareServerMessage.getPayload());
                if (pIParseResponse.isNoErrorStatusResponse()) {
                    hashtable = pIParseResponse.getParsedData(fSPCMReqTableEntry.getCmd());
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        int n = 2;
        if (hashtable != null) {
            object = fSPCMReqTableEntry.getRespHdlr();
            n = object.processAck(hashtable, fSPCMReqTableEntry.getCmdId());
        }
        if (n == 1) {
            this.mCmReqTable.deleteRow(fSPCMReqTableEntry.getReqId());
            if (this.mCmReqTable.emptyGroup(fSPCMReqTableEntry.getGroupId())) {
                object = fSPCMReqTableEntry.getReqThread();
                ((Thread)object).interrupt();
            }
        }
    }

    public void handleInData(HardwareServerMessage hardwareServerMessage) {
        int n = hardwareServerMessage.getMinorOpCode();
        int n2 = hardwareServerMessage.getMajorOpCode();
        if (n2 == 32 && (n == 59 || n == 60 || n == 74 || n == 75) && this.mAsyncListener != null) {
            this.mAsyncListener.setRegResp(hardwareServerMessage);
        } else if (n2 == 160 && (n == 131 || n == 132)) {
            System.out.println("is async data");
            this.mAsyncListener.addNewMessage(hardwareServerMessage);
        } else if (n2 == 80) {
            if (!hardwareServerMessage.isHSError()) {
                this.processResponse(hardwareServerMessage);
            } else {
                System.out.println("HS error");
            }
        }
    }

    private void handleOutDataForGroupCmd(FSPCMReqTableEntry fSPCMReqTableEntry, HardwareServerMessage hardwareServerMessage) {
        FSPCMRespThread fSPCMRespThread = new FSPCMRespThread(this, fSPCMReqTableEntry, hardwareServerMessage, 0);
        fSPCMRespThread.start();
    }

    private void handleRetryNoRespCmd(int n) {
        FSPCMRespThread fSPCMRespThread = new FSPCMRespThread(this, null, null, n);
        fSPCMRespThread.start();
    }

    private void processResponse(HardwareServerMessage hardwareServerMessage) {
        if (this.mClosed) {
            System.out.println("cmd conn closed, ignore resp");
            return;
        }
        try {
            System.out.println("Entering processResponse...");
            if (hardwareServerMessage.isHSError()) {
                System.out.println("hardware server error");
                return;
            }
            int n = hardwareServerMessage.getCorrelator();
            System.out.println("cmd reqId " + n);
            FSPCMReqTableEntry fSPCMReqTableEntry = (FSPCMReqTableEntry)this.mCmReqTable.get(new Integer(n));
            if (fSPCMReqTableEntry == null) {
                int n2;
                System.out.println(">>>>> cannot find entry for reqid: " + n);
                byte[] byArray = hardwareServerMessage.getPayload();
                if (!(hardwareServerMessage.getMajorOpCode() != 80 || hardwareServerMessage.getMinorOpCode() != 98 && hardwareServerMessage.getMinorOpCode() != 117 || (n2 = ((byArray[1] & 0xFF) << 8) + (byArray[0] & 0xFF)) != 1015 && n2 != 1004)) {
                    System.out.println("cmd be kicked out because of the previous cmd failed");
                    this.handleRetryNoRespCmd(n);
                    return;
                }
                System.out.println("_cmReqTable: " + this.mCmReqTable);
                return;
            }
            if (fSPCMReqTableEntry.getGroupId() != -1) {
                this.handleOutDataForGroupCmd(fSPCMReqTableEntry, hardwareServerMessage);
                return;
            }
            fSPCMReqTableEntry.setResp(hardwareServerMessage);
            Thread thread = fSPCMReqTableEntry.getReqThread();
            thread.interrupt();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private Object procResp(int n) throws PIHscCmdMgrException {
        FSPCMReqTableEntry fSPCMReqTableEntry = (FSPCMReqTableEntry)this.mCmReqTable.get(new Integer(n));
        if (fSPCMReqTableEntry == null) {
            System.out.println("cannot find reqEntry for: " + n + " mCmReqTable " + this.mCmReqTable);
            throw new PIHscCmdMgrException("0255", new String[]{"" + n}, (PIHscCmdMgrException)null);
        }
        this.mCmReqTable.deleteRow(n);
        HardwareServerMessage hardwareServerMessage = (HardwareServerMessage)fSPCMReqTableEntry.getResp();
        if (hardwareServerMessage == null) {
            return null;
        }
        if (fSPCMReqTableEntry.getEventType() == 1) {
            System.out.println("hardware server cmd");
            return hardwareServerMessage;
        }
        byte[] byArray = hardwareServerMessage.getPayload();
        if (hardwareServerMessage.getMajorOpCode() == 80 && hardwareServerMessage.getMinorOpCode() == 98) {
            int n2 = ((byArray[1] & 0xFF) << 8) + (byArray[0] & 0xFF);
            if (n2 == 1015 || n2 == 1004) {
                System.out.println("cmd be kicked out because of the previous cmd failed");
                throw new PIHscCmdMgrRetryException(fSPCMReqTableEntry.getCmd(), n2, byArray);
            }
            System.out.println("invoke error, status is " + n2);
            throw new PIHscCmdMgrException(fSPCMReqTableEntry.getCmd(), n2, byArray);
        }
        try {
            PIParseResponse pIParseResponse = new PIParseResponse(byArray);
            if (!pIParseResponse.isNoErrorStatusResponse()) {
                Hashtable hashtable = pIParseResponse.getErrorData();
                int n3 = (Integer)hashtable.get("ERROR_TYPE");
                if (n3 == 33006) {
                    CmdExtendedErrorList cmdExtendedErrorList = (CmdExtendedErrorList)hashtable.get("ERROR_DATA");
                    throw new PIHscCmdMgrException(fSPCMReqTableEntry.getCmd(), cmdExtendedErrorList, byArray);
                }
                throw new PIHscCmdMgrException(fSPCMReqTableEntry.getCmd(), n3, byArray);
            }
            Hashtable hashtable = pIParseResponse.getParsedData(fSPCMReqTableEntry.getCmd());
            System.out.println(">>>>> after parse resp ");
            return hashtable;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new PIHscCmdMgrException(fSPCMReqTableEntry.getCmd(), -1, byArray);
        }
    }

    int getPrimaryCount() {
        if (this.mQueryData == null) {
            return 0;
        }
        return this.mQueryData.getPrimaryCount();
    }

    static int getTimeoutValue() {
        return mTimeoutValue;
    }

    static {
        mTimeoutValue = DEFAULT_TIMEOUT = 180000;
        mTimeoutValue = DEFAULT_TIMEOUT;
        try {
            Properties properties = new Properties();
            properties.load(new FileInputStream("/opt/hsc/data/hmc.properties"));
            String string = properties.getProperty("HmcFspCmdDefaultTimeoutInSec");
            System.out.println("The timeout property is: " + string);
            if (string != null) {
                int n = Integer.parseInt(string);
                mTimeoutValue = n * 1000;
                System.out.println("mTimeoutValue: " + mTimeoutValue);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

